function [Q,R]=grasch(A)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function [Q,R]=grasch(A)
% Berechnet die reduzierte QR-Faktorisierung von A
% mit dem Gram-Schmidt-Verfahren
%
% A: (m x n)-Matrix, m>=n
% Q: spaltenorthonormale Matrix (m x n)-Matrix
% R: obere (n x n)-Dreiecksmatrix
%
[m,n]=size(A);
if n>m, error('Dimensionsfehler (n>m)'),end
Q=zeros(m,n);
R=zeros(n);
for k=1:n
    Q(:,k)=A(:,k);
    R(1:k-1,k)=Q(:,1:k-1)'*A(:,k);
    Q(:,k)=Q(:,k)-Q(:,1:k-1)*R(1:k-1,k);
    R(k,k)=norm(Q(:,k));
    if R(k,k) == 0
        error('Matrix A hat nicht vollen Rang')
    end
    Q(:,k)=Q(:,k)/R(k,k);
end
end