function [a,b,c,d]=espline(x,y,fs)
% Programmautoren: Prof. Dr. Martin Hermann und Dr. Dieter Kaiser
% function [a,b,c,d]=espline(x,y,fs)
% Berechnet die Koeffizienten-Vektoren a, b, c, d
% der eingespannten Splinefunktion S(x)
%
% x: Vektor der Stuetzstellen 
%    x(1) < x(2) ,..., x(n) < x(n+1)
% y: Vektor der Stuetzwerte y(1),...,y(n+1)
% fs: Vektor mit fs=[f'(x(1));f'(x(n+1))]
% a,b,c,d: Koeffizienten-Vektoren des Splines S(x)
%
n=length(x)-1;
x=x(:);y=y(:);
if length(x)~=length(y)
   error('Dimensionen von x und y muessen uebereinstimmen'),
end
h=x(2:n+1)-x(1:n);
a=y;
z=zeros(n+1,1);
q=zeros(n,1);l=q;mue=l;l(1)=1;
q(1)=3*(a(2)-a(1))/h(1)-3*fs(1);
q(n+1)=3*fs(2)-3*(a(n+1)-a(n))/h(n);
q(2:n)=3*(a(3:n+1).*h(1:n-1)-a(2:n).*(x(3:n+1)-x(1:n-1))...
       +a(1:n-1).*h(2:n))./(h(1:n-1).*h(2:n));
l(1)=2*h(1); mue(1)=.5; z(1)=q(1)/l(1);
for i=2:n
    l(i)=2*(x(i+1)-x(i-1))-h(i-1)*mue(i-1);
    mue(i)=h(i)/l(i); 
    z(i)=(q(i)-h(i-1)*z(i-1))/l(i);
end
b=z;c=z;d=z;
l(n+1)=h(n)*(2-mue(n)); z(n+1)=(q(n+1)-h(n)*z(n))/l(n+1); c(n+1)=z(n+1);
for j=n:-1:1
    c(j)=z(j)-mue(j)*c(j+1);
end
b(1:n)=(a(2:n+1)-a(1:n))./h(1:n)...
       -h(1:n).*(c(2:n+1)+2*c(1:n))/3;
d(1:n)=(c(2:n+1)-c(1:n))./(3*h(1:n));
end