LIBRARY ieee;
USE ieee.std_logic_1164.all;


ENTITY test_bench IS
END test_bench ;

ARCHITECTURE reg2_test OF test_bench IS

  COMPONENT reg2
    PORT ( clk  : IN  std_logic;
           d0   : IN  std_logic;
           d1   : IN  std_logic;
           load : IN  std_logic;
           res  : IN  std_logic;
           q0   : OUT std_logic;
           q1   : OUT std_logic);
  END COMPONENT;

  -- Stimulus Signale
  SIGNAL s_clk  : std_logic := '0';
  SIGNAL s_d0   : std_logic := '0';
  SIGNAL s_d1   : std_logic := '0';
  SIGNAL s_load : std_logic := '0';
  SIGNAL s_res  : std_logic := '0';

  -- Response Signale
  SIGNAL r_q0 : std_logic;
  SIGNAL r_q1 : std_logic;

BEGIN

  -- Verschaltung des DUV mit den Stimulus/Response-Signalen
  u1 : reg2
    PORT MAP(clk  => s_clk, d0   => s_d0, d1   => s_d1,
      load => s_load, res  => s_res, q0   => r_q0, q1   => r_q1);

  -- Taktgenerator
  s_clk <= NOT s_clk AFTER 5 ns;

  -- Stimuli
  stim : PROCESS
  BEGIN  -- PROCESS stim
    s_res <= '1';
    WAIT FOR 20 ns;
    s_res <= '0';
    s_d0 <= '1';
    WAIT FOR 20 ns;
    s_load <= '1';
    WAIT;
  END PROCESS stim;

  -- Abbruch der Simulation
  stop_sim: PROCESS
  BEGIN  -- PROCESS stop_sim
    WAIT FOR 100 ns;
    ASSERT false REPORT "simulation stopped" SEVERITY failure;
  END PROCESS stop_sim;

END reg2_test;
