ARCHITECTURE struct OF reg2 IS
   SIGNAL o1 : std_logic;
   SIGNAL o2 : std_logic;
   SIGNAL q0_internal : std_logic;
   SIGNAL q1_internal : std_logic;

   COMPONENT ff2
   PORT (
      clk : IN     std_logic ;
      d0  : IN     std_logic ;
      d1  : IN     std_logic ;
      res : IN     std_logic ;
      q0  : OUT    std_logic ;
      q1  : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT mux2
   PORT (
      a1  : IN     std_logic ;
      a2  : IN     std_logic ;
      b1  : IN     std_logic ;
      b2  : IN     std_logic ;
      sel : IN     std_logic ;
      o1  : OUT    std_logic ;
      o2  : OUT    std_logic 
   );
   END COMPONENT;

BEGIN

   I1 : ff2
      PORT MAP (
         clk => clk, d0  => o1, d1  => o2,
         res => res, q0  => q0_internal, q1  => q1_internal
      );
   I0 : mux2
      PORT MAP (
         a1  => d0, a2  => d1, b1  => q0_internal,
         b2  => q1_internal, sel => load, o1  => o1, o2  => o2
      );

   q0 <= q0_internal;
   q1 <= q1_internal;

END struct;
