LIBRARY ieee;
USE ieee.std_logic_1164.all;
PACKAGE BODY vc IS

  FUNCTION paritaet (
    CONSTANT width  : integer;
    SIGNAL   a      : std_logic_vector) RETURN std_logic IS
    VARIABLE parity : std_logic := '0';
  BEGIN
    FOR i IN 0 TO width-1 LOOP
      parity := parity XOR a(i);
    END LOOP;
    RETURN parity;
  END FUNCTION paritaet;

  PROCEDURE paritaet2 (
    CONSTANT width  : IN  integer;
    SIGNAL   a      : IN  std_logic_vector;
    SIGNAL   result : OUT std_logic) IS
    VARIABLE parity : std_logic := '0';
  BEGIN
    FOR i IN 0 TO width-1 LOOP
      parity := parity XOR a(i);
    END LOOP;
    result <= parity;
  END PROCEDURE paritaet2;

END vc;
