LIBRARY ieee;
USE ieee.std_logic_1164.all;


ENTITY shiftreg IS
   PORT( 
      a   : IN     std_logic;
      clk : IN     std_logic;
      res : IN     std_logic;
      y   : OUT    std_logic
   );
END shiftreg ;

ARCHITECTURE beh OF shiftreg IS
  SIGNAL y_s : std_logic_vector(3 DOWNTO 0);
BEGIN
  P1: PROCESS(clk, res)
  BEGIN
    IF res = '1' THEN
      FOR i IN 0 TO 3 LOOP
        y_s(i) <= '0';
      END LOOP;
    ELSIF clk'event AND clk = '1' THEN
      y_s(0) <= a;
      FOR i IN 0 TO 2 LOOP
        y_s(i+1) <= y_s(i);
      END LOOP;
    END IF;
  END PROCESS P1;
  y <= y_s(3);
END beh;
