ARCHITECTURE beh OF reg2 IS
  SIGNAL q0_s, q0_ns, q1_s, q1_ns : std_logic;
BEGIN
  
  reg: PROCESS (clk, res)
  BEGIN 
    IF res = '1' THEN                   
      q0_s <= '0';
      q1_s <= '0';
    ELSIF clk'event AND clk = '1' THEN 
      q0_s <= q0_ns;
      q1_s <= q1_ns;
    END IF;
  END PROCESS reg;

  q0 <= q0_s AFTER 2 ns;
  q1 <= q1_s AFTER 2 ns;
  
  mux: PROCESS (load, q0_s, q1_s, d0, d1)
  BEGIN
    IF load = '1' THEN
      q0_ns <= d0 AFTER 3 ns;
      q1_ns <= d1 AFTER 3 ns;
    ELSE
      q0_ns <= q0_s AFTER 4 ns;
      q1_ns <= q1_s AFTER 4 ns;
    END IF;
  END PROCESS mux;

END beh;
