ARCHITECTURE beh1 OF ctrl IS

  TYPE state_t IS (fetch, decode, execute);
  SIGNAL state: state_t;

  SIGNAL incpc, ldpc, ldir, ldacc, wrmem: std_logic;
  SIGNAL alumod, selbus: std_logic_vector(1 DOWNTO 0);

BEGIN

  -- FSM 
  fsm_reg: PROCESS (rst, clk)
  BEGIN
    IF (rst='1') THEN
      state <= fetch;
    ELSIF clk'event AND clk='1' THEN
      -- defaults for outputs (all signals active high)
      alumod <= "00";  -- ALU mode (cbus(1:0))
      ldir <= '0';   -- load IR (cbus(4))
      ldacc <= '0';  -- load accu from bus (cbus(5))
      wrmem <= '0';  -- write to memory (cbus(6))
      incpc <= '0';  -- increment PC (cbus(7))
      ldpc <= '0';   -- load PC (cbus(8))
      CASE state IS
        WHEN fetch =>
          state <= decode;
          ldir <= '1';         -- fetch next instruction from pmem
        WHEN decode =>
          state <= execute;
          IF opc(3) = '0'  THEN           -- adu, sbu, lda, mov
            alumod <= opc(1 DOWNTO 0); 
          END IF;
        WHEN execute =>
          state <= fetch;
          IF opc(3) = '0'  THEN           -- adu, sbu, lda, mov
            ldacc <= '1';
          END IF;
          IF opc(3 DOWNTO 2) = "10" THEN  -- str
            wrmem <= '1';
          END IF;
          IF opc = "1100" THEN            -- jmp
            ldpc <= '1';
          ELSE
            incpc <= '1';
          END IF;
      END CASE;
    END IF;
  END PROCESS fsm_reg;

  selbus <= opc(3 DOWNTO 2);

  cbus <= ldpc & incpc & wrmem & ldacc & ldir & selbus & alumod;
END beh1;
