LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY ctrl IS
   PORT( 
      clk  : IN     std_logic;
      opc  : IN     std_logic_vector (3 DOWNTO 0);
      rst  : IN     std_logic;
      cbus : OUT    std_logic_vector (8 DOWNTO 0)
   );
END ctrl ;

ARCHITECTURE beh OF ctrl IS

  TYPE state_t IS (fetch, decode, execute);
  SIGNAL state, nxstate : state_t;

  SIGNAL incpc, ldpc, ldir, ldacc, wrmem: std_logic;
  SIGNAL alumod, selbus: std_logic_vector(1 DOWNTO 0);

BEGIN

  -- FSM state register
  fsm_reg: PROCESS (rst, clk)
  BEGIN
    IF (rst='1') THEN
      state <= fetch;
    ELSIF clk'event AND clk='1' THEN
      state <= nxstate;
    END IF ;
  END PROCESS;

  -- next state logic for FSM
  next_state : PROCESS (state)	
  BEGIN
    CASE state IS
      WHEN fetch =>
        nxstate <= decode;
      WHEN decode =>
        nxstate <= execute;
      WHEN execute =>
        nxstate <= fetch;
    END CASE;
  END PROCESS next_state;

  -- output decoder for FSM (Mealy type)
  output_decoder : PROCESS (state, opc)
  BEGIN 
    -- defaults for outputs (all signals active high)
    alumod <= "00";  -- ALU mode (cbus(1:0))
    ldir <= '0';   -- load IR (cbus(4))
    ldacc <= '0';  -- load accu from bus (cbus(5))
    wrmem <= '0';  -- write to memory (cbus(6))
    incpc <= '0';  -- increment PC (cbus(7))
    ldpc <= '0';   -- load PC (cbus(8))
    CASE state IS
      WHEN fetch =>
        ldir <= '1';  		-- fetch next instruction from pmem
      WHEN decode =>
        IF opc(3) = '0'  THEN           -- adu, sbu, lda, mov
          alumod <= opc(1 DOWNTO 0); 
        END IF;
      WHEN execute =>
        IF opc(3) = '0'  THEN           -- adu, sbu, lda, mov
          ldacc <= '1';
        END IF;
        IF opc(3 DOWNTO 2) = "10" THEN  -- str
          wrmem <= '1';
        END IF;
        IF opc = "1100" THEN            -- jmp
          ldpc <= '1';
        ELSE
          incpc <= '1';
        END IF;
    END CASE;
  END PROCESS output_decoder;

  selbus <= opc(3 DOWNTO 2);

  cbus <= ldpc & incpc & wrmem & ldacc & ldir & selbus & alumod;
END beh;
