LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY flipflop IS
   PORT( 
      clk : IN     std_logic;
      d   : IN     std_logic;
      res : IN     std_logic;
      set : IN     std_logic;
      q   : OUT    std_logic
   );
END flipflop ;

ARCHITECTURE beh1 OF flipflop IS
  SIGNAL q_s : std_logic;
BEGIN
  
  reg: PROCESS (clk, res, set)
  BEGIN 
    IF res = '1' THEN           
      q_s <= '0';
    ELSIF set = '1' THEN           
      q_s <= '1';
    ELSIF rising_edge(clk) THEN
      q_s <= d;
    END IF;
  END PROCESS reg;

  q <= q_s;
  
END beh1;
