LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY pio IS
   PORT( 
      addr    : IN     std_logic_vector (3 DOWNTO 0);
      clk     : IN     std_logic;
      din     : IN     std_logic_vector (3 DOWNTO 0);
      rst     : IN     std_logic;
      we      : IN     std_logic;
      dout    : OUT    std_logic_vector (3 DOWNTO 0);
      pioport : INOUT  std_logic_vector (3 DOWNTO 0));
END pio ;

ARCHITECTURE beh OF pio IS
  SIGNAL piomode, pioread, piowrite : std_logic_vector(3 DOWNTO 0);
BEGIN

  pioregs : PROCESS (clk, rst)
  BEGIN
    IF rst = '1' THEN
      piomode <= "1111";
      pioread <= "0000";
      piowrite <= "0000";
    ELSIF clk'event AND clk = '1' THEN
      IF addr(3 DOWNTO 2) = "11" AND we = '1' THEN
        piomode <= din;  
      END IF;
      IF addr(3 DOWNTO 1) = "101" AND we = '1' THEN
        piowrite <= din; 
      END IF;
      pioread <= pioport;
    END IF;
  END PROCESS pioregs;

  pioport(3) <= piowrite(3) WHEN piomode(3)='0' ELSE 'Z'; 
  pioport(2) <= piowrite(2) WHEN piomode(2)='0' ELSE 'Z';
  pioport(1) <= piowrite(1) WHEN piomode(1)='0' ELSE 'Z';
  pioport(0) <= piowrite(0) WHEN piomode(0)='0' ELSE 'Z';

  dout <= pioread WHEN addr(3) = '1' ELSE "0000";
  
END beh;
