LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY transceiver_tri IS
   PORT( 
      bus_read  : IN     std_logic;
      bus_write : IN     std_logic;
      clk       : IN     std_logic;
      di        : IN     std_logic;
      res       : IN     std_logic;
      do        : OUT    std_logic;
      bus_inout : INOUT  std_logic
   );
END transceiver_tri ;

ARCHITECTURE beh OF transceiver_tri IS
  SIGNAL q : std_logic;
BEGIN 

  dff: PROCESS (clk, res)
  BEGIN 
    IF res = '1' THEN
      q <= '0';
    ELSIF clk'event AND clk = '1' THEN
      IF bus_read = '1' THEN
        q <= bus_inout;
      ELSE
        q <= di;
      END IF;
    END IF;
  END PROCESS dff;

  do <= q;
  bus_inout <= q WHEN bus_write = '1' ELSE 'Z';

END beh;
