LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY fsm1 IS
  PORT( 
    clk : IN     std_logic;
    r   : IN     std_logic;
    res : IN     std_logic;
    s   : IN     std_logic;
    y   : OUT    std_logic
    );
END fsm1 ;

ARCHITECTURE beh OF fsm1 IS

  CONSTANT s0 : std_logic := '1';
  CONSTANT s1 : std_logic := '0';

  SIGNAL current_state : std_logic ;
  SIGNAL next_state : std_logic ;

BEGIN

  statereg : PROCESS(clk, res)
  BEGIN
    IF (res = '1') THEN
      current_state <= s0;
    ELSIF (clk'event AND clk = '1') THEN
      current_state <= next_state;
    END IF;
  END PROCESS statereg;

  nextstate : PROCESS (current_state, r, s)
  BEGIN
    y <= '0';
    next_state <= current_state;
    CASE current_state IS
      WHEN s0 =>
        y <= '0';
        IF (s = '1' AND r = '0') THEN
          next_state <= s1;
        END IF;
      WHEN s1 =>
        y <= '1';
        IF (r = '1' AND s='0') THEN
          next_state <= s0;
        END IF;
      WHEN OTHERS => NULL;
    END CASE;
  END PROCESS nextstate;

END beh;
