LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY transceiver_log IS
   PORT( 
      bus_in    : IN     std_logic;
      bus_read  : IN     std_logic;
      bus_write : IN     std_logic;
      clk       : IN     std_logic;
      di        : IN     std_logic;
      res       : IN     std_logic;
      bus_out   : OUT    std_logic;
      do        : OUT    std_logic
   );
END transceiver_log ;

ARCHITECTURE beh OF transceiver_log IS
  SIGNAL q : std_logic;
BEGIN  -- beh

  dff: PROCESS (clk, res)
  BEGIN 
    IF res = '1' THEN
      q <= '0';
    ELSIF clk'event AND clk = '1' THEN
      IF bus_read = '1' THEN
        q <= bus_in;
      ELSE
        q <= di;
      END IF;
    END IF;
  END PROCESS dff;

  do <= q;
  bus_out <= q WHEN bus_write = '1' ELSE '0';

END beh;
