LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY dbus IS
   PORT( 
      alu  : IN     std_logic_vector (3 DOWNTO 0);
      con  : IN     std_logic_vector (3 DOWNTO 0);
      mem  : IN     std_logic_vector (3 DOWNTO 0);
      pio  : IN     std_logic_vector (3 DOWNTO 0);
      sel  : IN     std_logic_vector (1 DOWNTO 0);
      dout : OUT    std_logic_vector (3 DOWNTO 0));
END dbus ;

ARCHITECTURE beh OF dbus IS
  SIGNAL membus : std_logic_vector(3 DOWNTO 0);
BEGIN

  membus <= mem OR pio;

  busmux: PROCESS (sel, con, alu, membus, pio)
  BEGIN
    CASE sel IS
      WHEN "00" => dout <= membus;
      WHEN "01" => dout <= con;
      WHEN "10" | "11" => dout <= alu;
      WHEN OTHERS => NULL;
    END CASE;  
  END PROCESS busmux;

END beh;
