ARCHITECTURE beh1 OF pmem IS

  COMPONENT prom16x8
    PORT (
      addr: IN std_logic_vector(3 DOWNTO 0);
      clk: IN std_logic;
      dout: OUT std_logic_vector(7 DOWNTO 0);
      en: IN std_logic);
  END COMPONENT;

  SIGNAL ireg : std_logic_vector(7 DOWNTO 0);
  SIGNAL pc : unsigned(3 DOWNTO 0);
  
BEGIN

  -- Program Counter pc
  pcreg: PROCESS (clk, rst)
  BEGIN 
    IF rst = '1' THEN
      pc <= "0000";
    ELSIF clk'event AND clk = '1' THEN 
      IF ldpc = '1' THEN
        pc <= unsigned(ireg(3 DOWNTO 0));
      ELSIF incpc = '1' THEN
        pc <= pc + 1;
      END IF;
    END IF;
  END PROCESS pcreg;

  i0 : prom16x8
    PORT MAP (
      addr => std_logic_vector(pc),
      clk => clk,
      dout => ireg,
      en => ldir);
  
  adcon <= ireg(3 DOWNTO 0);
  opc <= ireg(7 DOWNTO 4);
  
END beh1;
