LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

ENTITY dmem IS
   PORT( 
      addr : IN     std_logic_vector (3 DOWNTO 0);
      clk  : IN     std_logic;
      din  : IN     std_logic_vector (3 DOWNTO 0);
      we   : IN     std_logic;
      dout : OUT    std_logic_vector (3 DOWNTO 0)
   );
END dmem ;

ARCHITECTURE beh OF dmem IS

  TYPE ram_t IS ARRAY (7 DOWNTO 0) OF std_logic_vector(3 DOWNTO 0);
  SIGNAL ram : ram_t;
  
BEGIN

  -- RAM with synchronous write and asynchronous read
  p0 : PROCESS (clk)
  BEGIN 
    IF clk'event AND clk = '1' THEN
      IF addr(3) = '0' AND we = '1' THEN
        ram(to_integer(unsigned(addr(2 DOWNTO 0)))) <= din;
      END IF;
    END IF;
  END PROCESS p0;

  dout <= ram(to_integer(unsigned(addr(2 DOWNTO 0))))
          WHEN addr(3) = '0' ELSE "0000";
  
END beh;
