LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

ENTITY ram IS
  GENERIC( 
    aw : integer := 12;
    dw : integer := 4
    );
  PORT( 
    addr : IN     std_logic_vector (aw-1 DOWNTO 0);
    clk  : IN     std_logic;
    din  : IN     std_logic_vector (dw-1 DOWNTO 0);
    we   : IN     std_logic;
    dout : OUT    std_logic_vector (dw-1 DOWNTO 0)
    );
END ram ;

ARCHITECTURE beh OF ram IS

  TYPE ram_t IS ARRAY ((2**aw-1) DOWNTO 0) OF
                std_logic_vector(dw-1 DOWNTO 0);
  SIGNAL ram : ram_t;

BEGIN

  -- RAM with synchronous write and synchronous read
  p0 : PROCESS (clk)
  BEGIN
    IF clk'event AND clk = '1' THEN
      IF  we = '1' THEN
        ram(to_integer(unsigned(addr))) <= din;
      END IF;
      dout <= ram(to_integer(unsigned(addr)));
    END IF;
  END PROCESS p0;

END beh;
