LIBRARY ieee;
USE ieee.std_logic_1164.all;
PACKAGE p4def IS

  -- Define type for ROM array
  TYPE rom_t IS ARRAY (0 TO 15) OF std_logic_vector(7 DOWNTO 0);

  -- Define Opcodes for P4
  CONSTANT adu : std_logic_vector(3 DOWNTO 0) := "0001";
  CONSTANT sbu : std_logic_vector(3 DOWNTO 0) := "0010";
  CONSTANT lda : std_logic_vector(3 DOWNTO 0) := "0011";
  CONSTANT mov : std_logic_vector(3 DOWNTO 0) := "0111";
  CONSTANT str : std_logic_vector(3 DOWNTO 0) := "1000";
  CONSTANT jmp : std_logic_vector(3 DOWNTO 0) := "1100";
  CONSTANT nop : std_logic_vector(3 DOWNTO 0) := "1111";

  -- Define ROM content: Program for P4
  CONSTANT rom : rom_t := 
    (
     mov & x"0",  -- 0: accu <- 0
     str & x"c",  -- 1: mem[c] <- accu
     mov & x"1",  -- 2: accu <- 1
     str & x"0",  -- 3: mem[0] <- accu
     mov & x"0",  -- 4: accu <- 0
     sbu & x"0",  -- 5: accu <- accu - mem[0]
     str & x"a",  -- 6: mem[a] <- accu
     str & x"7",  -- 7: mem[7] <- accu
     adu & x"7",  -- 8: accu <- accu + mem[7]
     str & x"a",  -- 9: mem[a] <- accu
     adu & x"0",  -- a: accu <- accu + mem[0]
     str & x"a",  -- b: mem[a] <- accu
     adu & x"0",  -- c: accu <- accu + mem[0]
     str & x"a",  -- d: mem[a] <- accu
     nop & x"f",  -- e: nop
     jmp & x"2"); -- f: pc <- 2

END p4def;
