LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

LIBRARY p4;
USE p4.p4def.all;

ENTITY pmem IS
   PORT( 
      clk   : IN     std_logic;
      incpc : IN     std_logic;
      ldir  : IN     std_logic;
      ldpc  : IN     std_logic;
      rst   : IN     std_logic;
      adcon : OUT    std_logic_vector (3 DOWNTO 0);
      opc   : OUT    std_logic_vector (3 DOWNTO 0)
   );
END pmem ;

ARCHITECTURE beh OF pmem IS

  SIGNAL ir : std_logic_vector(7 DOWNTO 0);
  SIGNAL pc : unsigned(3 DOWNTO 0);
  
BEGIN

  pcreg: PROCESS (clk, rst)
  BEGIN 
    IF rst = '1' THEN
      pc <= "0000";
    ELSIF clk'event AND clk = '1' THEN 
      IF ldpc = '1' THEN
        pc <= unsigned(ir(3 DOWNTO 0));
      ELSIF incpc = '1' THEN
        pc <= pc + 1;
      END IF;
    END IF;
  END PROCESS pcreg;

  irom: PROCESS (clk)
  BEGIN 
    IF clk'event AND clk = '1' THEN      
      IF ldir = '1' THEN
        ir <= rom(to_integer(pc));
      END IF;
    END IF;
  END PROCESS irom;

  adcon <= ir(3 DOWNTO 0);
  opc <= ir(7 DOWNTO 4);
  
END beh;
