LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

ENTITY add IS
   GENERIC( 
      width : integer := 3
   );
   PORT( 
      a    : IN     std_logic_vector (width-1 DOWNTO 0);
      b    : IN     std_logic_vector (width-1 DOWNTO 0);
      cin  : IN     std_logic;
      cout : OUT    std_logic;
      s    : OUT    std_logic_vector (width-1 DOWNTO 0)
   );
END add ;

ARCHITECTURE uns OF add IS
  SIGNAL sout : unsigned(width DOWNTO 0);
  CONSTANT c : std_logic_vector(width-1 DOWNTO 0) := (OTHERS => '0');
BEGIN -- Verwendet nur nebenlaeufige Anweisungen
  sout <= unsigned('0'&a) + unsigned('0'&b) + unsigned(c&cin);
  s <= std_logic_vector(sout(width-1 DOWNTO 0));
  cout <= std_logic(sout(width));
END uns;
