LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

ENTITY alu IS
   PORT( 
      clk   : IN     std_logic;
      din   : IN     std_logic_vector (3 DOWNTO 0);
      ldacc : IN     std_logic;
      mode  : IN     std_logic_vector (1 DOWNTO 0);
      rst   : IN     std_logic;
      dout  : OUT    std_logic_vector (3 DOWNTO 0)
   );
END alu ;

ARCHITECTURE beh OF alu IS

  SIGNAL accu, data_s, res : unsigned(3 DOWNTO 0);
  SIGNAL mode_s : std_logic_vector(1 DOWNTO 0);
  
BEGIN

  regs: PROCESS (clk, rst)
  BEGIN 
    IF rst = '1' THEN 
      data_s <= "0000";
      mode_s <= "00";
      accu <= "0000";
    ELSIF clk'event AND clk = '1' THEN
      data_s <= unsigned(din);
      mode_s <= mode;
      IF ldacc = '1' THEN
        accu <= res;
      END IF;
    END IF;
  END PROCESS regs;

  compute: PROCESS (accu, data_s, mode_s)
  BEGIN
    IF mode_s = "01" THEN
      res <= accu + data_s;
    ELSIF mode_s = "10" THEN
      res <= accu - data_s;
    ELSE
      res <= data_s;
    END IF;
  END PROCESS compute;

  dout <= std_logic_vector(accu);
  
END beh;
