LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;

ENTITY ctrld IS
  GENERIC( 
    width : integer := 4
    );
  PORT( 
    clk : IN     std_logic;
    res : IN     std_logic;
    a   : IN     std_logic_vector (width-1 DOWNTO 0);
    y   : OUT    std_logic_vector (width-1 DOWNTO 0)
    );
END ctrld ;

ARCHITECTURE beh1 OF ctrld IS
  SIGNAL ctr_s : unsigned(width-1 DOWNTO 0);
  CONSTANT zero : unsigned(width-1 DOWNTO 0) := (OTHERS => '0');
BEGIN

  ctr : PROCESS (clk, res)
  BEGIN 
    IF res = '1' THEN
      ctr_s <= zero;
    ELSIF clk'event AND clk = '1' THEN
      IF ctr_s = unsigned(a) THEN
        ctr_s <= zero;
      ELSE
        ctr_s <= ctr_s + 1;
      END IF;
    END IF;
  END PROCESS ctr;

  y <= std_logic_vector(ctr_s);

END beh1;
