LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY regvar IS
   PORT( 
      clock    : IN     std_logic;
      reset    : IN     std_logic;
      shiftin  : IN     std_logic;
      shiftout : OUT    std_logic );
END regvar ;

ARCHITECTURE beh OF regvar IS
  SIGNAL sout : std_logic;
BEGIN 

  shift: PROCESS (clock, reset)
    VARIABLE a, b : std_logic;  -- local variables
  BEGIN
    IF reset = '1' THEN                
      a := '0';
      b := '0';
      sout <= '0';
    ELSIF clock'event AND clock = '1' THEN
      a := shiftin;
      b := a;
      sout <= b;
    END IF;
  END PROCESS shift;

  shiftout <= sout;
END beh;
