LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;

ENTITY ctr IS
   GENERIC(width : integer := 3);
   PORT(clk : IN     std_logic;
      res : IN     std_logic;
      div : OUT    std_logic);
END ctr ;

ARCHITECTURE beh OF ctr IS
  SIGNAL count : unsigned(width-1 DOWNTO 0);
BEGIN 

  reg: PROCESS (clk, res)
  BEGIN
    IF res = '0' THEN                 
      count <= (others=>'0');
    ELSIF clk'event AND clk = '1' THEN
      count <= count+1;
    END IF;
  END PROCESS reg;
  
  div <= NOT count(width-1);

END beh;
