LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY shiftreg IS
   GENERIC( width : integer := 4);
   PORT(
      clk  : IN     std_logic;
      res  : IN     std_logic;
      sin  : IN     std_logic;
      sout : OUT    std_logic);
END shiftreg ;

ARCHITECTURE beh OF shiftreg IS
  SIGNAL shift : std_logic_vector(width-1 DOWNTO 0);
BEGIN

  reg: PROCESS (clk, res)
  BEGIN
    IF res = '1' THEN
      shift <= (OTHERS => '0');
    ELSIF clk'event AND clk = '1' THEN 
      shift(0) <= sin;
      FOR i IN 0 TO width-2 LOOP
        shift(i+1) <= shift(i);
      END LOOP;
    END IF;
  END PROCESS reg;
  
  sout <= shift(width-1);

END beh;
