LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;

ENTITY ctr2_tb IS
END ctr2_tb ;
ARCHITECTURE beh OF ctr2_tb IS

  SIGNAL clk, res, div : std_logic := '0';

  COMPONENT ctr IS GENERIC(width : integer := 2);
                PORT(
                  clk : IN  std_logic;
                  res : IN  std_logic;
                  div : OUT std_logic
                  );
  END COMPONENT;

  CONSTANT restime : time := 120 ns;
  CONSTANT clktime : time := 1.756 ns;

BEGIN  -- beh
  clk <= NOT clk AFTER clktime/2;
  res <= '1'     AFTER restime;

  i0 : ctr
    PORT MAP (
      clk => clk,
      res => res,
      div => div);

  finish : PROCESS
  BEGIN
    WAIT FOR 300 ns;
    ASSERT false REPORT "Simulation End" SEVERITY failure;
  END PROCESS;

END beh;

LIBRARY vcbuchk5_1;
CONFIGURATION ctr2_cfg_rtl OF ctr2_tb IS
  FOR beh
    FOR ALL : ctr
      USE ENTITY vcbuchk5_1.ctr(beh);
    END FOR;
  END FOR;
END ctr2_cfg_rtl;

LIBRARY vcbuchk5_1;
CONFIGURATION ctr2_cfg_gate OF ctr2_tb IS
  FOR beh
    FOR ALL : ctr
      USE ENTITY vcbuchk5_1.ctr(Structure);
    END FOR;
  END FOR;
END ctr2_cfg_gate;
