library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library SIMPRIM;
use SIMPRIM.VCOMPONENTS.ALL;
use SIMPRIM.VPACKAGE.ALL;
entity ctr is
  port (
    div : out STD_LOGIC; 
    clk : in STD_LOGIC := 'X'; 
    res : in STD_LOGIC := 'X' 
  );
end ctr;

architecture Structure of ctr is
  ......
begin
  count_1_YUSED : X_BUF_PP
    port map (
      I => count_1_G,
      O => count_nx4
    );
  count_1_DYMUX_3 : X_BUF_PP
    port map (
      I => count_nx4,
      O => count_1_DYMUX
    );
  count_1_Q : X_FF
    port map (
      I => count_1_DYMUX,
      CE => VCC,
      CLK => count_1_CLKINV,
      SET => GND,
      RST => count_1_FFY_RST,
      O => count(1)
    );
  ix41 : X_LUT4
    generic map(
      INIT => X"33CC"
    )
    port map (
      ADR0 => VCC,
      ADR1 => a(0),
      ADR2 => VCC,
      ADR3 => count(1),
      O => count_1_G
    );
  a_0_BYINV : X_INV
    port map (
      I => a(0),
      O => a_0_BYINVNOT
    );
  a_0_DYMUX_6 : X_BUF_PP
    port map (
      I => a_0_BYINVNOT,
      O => a_0_DYMUX
    );
  count_ix9 : X_FF
    port map (
      I => a_0_DYMUX,
      CE => VCC,
      CLK => a_0_CLKINV,
      SET => GND,
      RST => a_0_FFY_RST,
      O => a(0)
    );
  ......
end Structure;
