#include "accumulator.h"
 
int main () {

	// Input array
	// Channels:    C0  C1  C2  C3  C4  C5  C6  C7
	din_t d_i[N] = {10, 20, 30, 40, 50, 60, 70, 80, //Sample 0
					11, 21, 31, 41, 51, 61, 71, 81, //Sample 1
					12, 22, 32, 42, 52, 62, 72, 82, //Sample 2
					13, 23, 33, 43, 53, 63, 73, 83};//Sample 3
					
	//Output array (organization same as input array) 
	dout_t d_o[N];
	
	int i, retval=0;
	FILE        *fp;

	// Execute the DUT
	accumulator(d_o,d_i);

	// Save the results to a file
	fp=fopen("result.dat","w");
	fprintf(fp, "Din Dout\n");
	for (i=0;i<N;i++) {
    fprintf(fp, "%d   %d\n", d_i[i], d_o[i]);
	}
	fclose(fp);

	// Compare the results file with the golden results
	retval = system("diff --brief -w result.dat result.golden.dat");
	if (retval != 0) {
		printf("Test failed  !!!\n"); 
		retval=1;
	} else {
		printf("Test passed !\n");
  }

	// Return 0 if the test passes
	return retval;
}
