% Skript poly_interp_2.m, in dem eine Interpolierung mit Polyphasenfilter
% untersucht wird. Arbeitet mit Modell poly_interp1.slx und Unbuffer-Block

clear;
% --------- Parameter des Modells
fs = 1000;     Ts = 1/fs;  % Abtastfrequenz und Abtastperiode
fp = 0.2;  % Relative Frequenz fr die Bildung des Eingangssignals
nord1 = 32;% Ordnung des Filters
hTP = fir1(nord1, fp);    % Einheitspulsantwort

L = 4;     % Interpolierungsfaktor
nord2 = 32;  % Ordnung des FIR-Interpolierungsfilters
hint = fir1(nord2, 1/L);  % Einheitspulsantwort
g = firpolyphase(hint, L);

figure(1);   clf;
subplot(311);   stem(0:nord1, hint);
title(['Einheitspulsantwort des Interpolationsfilters L = ',num2str(L)]);
xlabel('n');    grid on;   axis tight;
subplot(323);   stem(0:nord1/L, g(1,:));
title('Polyphasefilter g0[n]');
grid on;   axis tight;
subplot(324);   stem(0:nord1/L, g(2,:));
title('Polyphasefilter g1[n]');
grid on;   axis tight;
subplot(325);   stem(0:nord1/L, g(3,:));
title('Polyphasefilter g2[n]');
xlabel('n');    grid on;   axis tight;
subplot(326);   stem(0:nord1/L, g(4,:));
title('Polyphasefilter g3[n]');
xlabel('n');    grid on;   axis tight;

% ------- Aufruf der Simulation
Tsim = 5;
sim('poly_interp1', [0:Ts:Tsim]);
y1 = y.Data(:,1);    % Interpolierungsausgang ohne Polyphasenfilter
y2 = y.Data(:,2);    % Mit Polyphasenfilter
y3 = y.Data(:,2);    % Mit Block FIR Interpolation (mit Polyphasenfilter) 
t = y.Time;          % Simulationszeiten
figure(2);   clf;
subplot(311), stem(t, y1);
title('Interpoliertes Signal ohne Polyphasenfiltern')
xlabel('s');    grid on;
La = axis;      axis([2, 2.15, La(3:4)]);
subplot(312), stem(t, y2);
title('Interpoliertes Signal mit Polyphasenfiltern')
xlabel('s');    grid on;
La = axis;      axis([2, 2.15, La(3:4)]);
subplot(313), stem(t, y3);
title('Interpoliertes Signal mit Block FIR Interpolation')
xlabel('s');    grid on;
La = axis;      axis([2, 2.15, La(3:4)]);
