% Skript poly_dez_1.m, in dem eine Dezimierung mit Polyphasenfilter
% untersucht wird. Arbeitet mit Modell poly_dez1.slx

clear;
% --------- Parameter des Modells
fs = 1000;     Ts = 1/fs;  % Abtastfrequenz und Abtastperiode
fp = 0.4;  % Relative Frequenz fr die Bildung des Eingangssignals
nord1 = 32;% Ordnung des Filters
hTP = fir1(nord1, fp);    % Einheitspulsantwort

M = 4;     % Dezimierungsfaktor
nord2 = 32;  % Ordnung des antialiasing Dezimierungsfilters
hdez = fir1(nord2, 1/M);  % Einheitspulsantwort

g = firpolyphase(hdez, M);
figure(1);   clf;
subplot(311);   stem(0:nord1, hdez);
title(['Einheitspulsantwort des Dezimierungsfilters M = ',num2str(M)]);
xlabel('n');    grid on;   axis tight;
subplot(323);   stem(0:nord1/M, g(1,:));
title('Polyphasefilter g0[n]');
grid on;   axis tight;
subplot(324);   stem(0:nord1/M, g(2,:));
title('Polyphasefilter g1[n]');
grid on;   axis tight;
subplot(325);   stem(0:nord1/M, g(3,:));
title('Polyphasefilter g2[n]');
xlabel('n');    grid on;   axis tight;
subplot(326);   stem(0:nord1/M, g(4,:));
title('Polyphasefilter g3[n]');
xlabel('n');    grid on;   axis tight;

% ------- Aufruf der Simulation
Tsim = 5;
sim('poly_dez1', [0:Ts:Tsim]);
y1 = y.Data(:,1);    % Dezimierungsausgang ohne Polyphasenfilter
y2 = y.Data(:,2);    % Mit Polyphasenfilter
t = y.Time;          % Simulationszeiten
figure(2);   clf;
subplot(211), stem(t, y1);
title('Dezimiertes Signal ohne Polyphasenfiltern')
xlabel('s');    grid on;
La = axis;      axis([2, 2.25, La(3:4)]);
subplot(212), stem(t, y2);
title('Dezimiertes Signal mit Polyphasenfiltern')
xlabel('s');    grid on;
La = axis;      axis([2, 2.25, La(3:4)]);

