% Skript lagrange_3.m in demeine Interpolierung mit der Funktion
% intfilt untersucht wird

clear;
% ------- Parameter der Interpolierung
L = 10;     N = 5;
h = intfilt(L,N,'Lagrange');    % Lagrange-FIR-Filter
nh = length(h);
% ------- Bandbegrenztes Signal
ns = 100;
s = rng;
x = randn(1,ns); % Abtastwerte
rng(s);
hTP = fir1(40, 0.5);    % Tiefpassfilter fr das bandbegrenztes Signal
w = filter(hTP,1,x);    % Bandbegrenztes Signal
% ------- Mit Nullwerten expandiertes Signal
wexp = zeros(1,L*ns);
wexp(1:L:end) = w;
% ------- Interpolierte Sequenz
y = filter(h,1,wexp);

figure(1);     clf;
stem(0:L:ns*L-1, w) ;
hold on; plot(0:ns*L-1, [y((nh-1)/2+1:end), zeros(1,(nh-1)/2)]); 
     % Nach vorne gerichtetes interpoliertes Signal
La = axis;    axis([400, 700, La(3:4)]);
title(['Bandbegrenzte Abtastwerte und interpoliertes Signal fr ',...
    'L = ',num2str(L),' und N = ', num2str(N),' (Ausschnitt)'])
xlabel('n');   grid on;

figure(2);    clf;
subplot(211), stem(0:nh-1, h);
title('Einheitspulsantwort des FIR-Lagrangefilters')
xlabel('n');    grid on;
nfft = 512;
H = fft(h,nfft);
subplot(212), plot((0:nfft-1)/nfft, 20*log10(abs(H)));
title('Amplitudengang des FIR-Lagrangefilters')
xlabel('Relative Frequenz f/fs');    grid on;
