
function pn = lagrange_2(xk, wk, x);
% Funktion lagrange_2.m, in der die Interpolierung mit Lagrange
% Polynome untersucht werden kann
% xk, wk = die zu interpolierende Sequenz
% x = an diesen Stellen soll interpoliert werden
% Testaufruf: xk = [1     2     3     6     8     9];
%             wk = [2    -1     3     4     6    0.5];
%             x = 1:0.2:9;
%             pn = lagrange_2(xk, wk, x);

N = length(xk);
nx = length(x);
% --------- Lagrange Polynome
pn = zeros(1,nx);
lk = zeros(N,nx);
for k = 1:N
    lk(k,:) = ones(1,nx);
    for j = [1:k-1, k+1:N]       % Es fehlt j = k
        lk(k,:) = ((x-xk(j))./(xk(k)-xk(j))).*lk(k,:);
    end;
    pn = pn + lk(k,:)*wk(k);
end;

figure(1);   clf;
plot(x, lk');
title('Die Lagrange-Interpolationspolynome');
xlabel('x');     grid on;
hold on;    stem(xk, zeros(1,N));  stem(xk, ones(1,N)); 
hold off;

figure(2);   clf;
plot(x, pn);
hold on;    stem(xk, wk); 
title('Die zu interpolierenden Werte und die interpolierte Funktion');
xlabel('x');     grid on;
