% Skript lagrange_1.m, in dem die Interpolierung mit Lagrange
% Polynome untersucht wird

clear;
% --------- Parameter der Simulation
N = 4;
xk = 0:N-1;        % Sttzstellen
s = rng;
wk = randn(1,N); % Funktionswerte
rng(s);
x = 0:0.1:N-1;     % Die zu interpolierenden Sttzstellen
nx = length(x);
% --------- Lagrange Polynome
pn = zeros(1,nx);
lk = zeros(N,nx);
for k = 1:N
    lk(k,:) = ones(1,nx);
    for j = [1:k-1, k+1:N]       % Es fehlt j = k
        lk(k,:) = ((x-xk(j))./(xk(k)-xk(j))).*lk(k,:);
    end;
    pn = pn + lk(k,:)*wk(k);
end;

figure(1);   clf;
subplot(511), plot(x, lk(1,:));
grid on;    hold on;
stem(xk, [1,zeros(1,N-1)]);
title('Polynom l0(x)');   hold off;

subplot(512), plot(x, lk(2,:));
grid on;    hold on;
stem(xk, [0, 1, zeros(1,N-2)]);
title('Polynom l1(x)');   hold off;

subplot(513), plot(x, lk(3,:));
grid on;    hold on;
stem(xk, [0, 0, 1, zeros(1,N-3)]);
title('Polynom l2(x)');   hold off;

subplot(514), plot(x, lk(4,:));
grid on;    hold on;
stem(xk, [zeros(1,N-1),1]);
title('Polynom l3(x)');   hold off;

subplot(515), plot(x, pn);
hold on;    stem(xk, wk);    hold off;
title('Die zu interpolierenden Werte und die interpolierte Funktion');
xlabel('x');     grid on;

figure(2);   clf;
plot(x, pn);
hold on;    stem(xk, wk);    hold off;
title('Die zu interpolierenden Werte und die interpolierte Funktion');
xlabel('x');     grid on;
