% Skript interpol_3.m, in dem eine Interpolation mit Faktor
% L untersucht wird.

clear;
% -------- Eingangssignal
fp = 18e3;       % fmax Signal in Hz 
naord = 8;      % Ordnung des Filters fr das Nutzsignal
dp = 1;         % Welligkeit im Durchlassbereich und 
ds = 60;        % Dmpfung im Sperrbereich  
[b,a] = cheby1(naord, dp, 0.85*2*pi*fp, 's');
[H, w] = freqs(b,a,512);
figure(1);     clf; % ----------------------
subplot(211), semilogx(w/(2*pi), 20*log10(abs(H)));
title(['Amplitudengang des analogen Tiefpassfilters fr das'...
    ' Eingangssignal']);
xlabel('Frequenz in Hz');     grid on;    axis tight;
subplot(212), semilogx(w/(2*pi), angle(H));
title('Phasengang des analogen Tiefpassfilters fr das Eingangssignal');
xlabel('Frequenz in Hz');     grid on;    axis tight;
axis tight;

% -------- Parameter des Interpolationssystems in zwei Stufen
% mit je einem Interpolationsfaktor 10
L1 = 20;
fs = 44.1e3;    % Abtastfrequenz des Eingangssignals
Ts = 1/fs;      % Abtastperiode
fs_prim = fs*L1; % Abtastfrequenz des interpolierten Signals der 
% ersten Stufe
L2 = 8;
fs_sec = fs_prim*L2; % der zweiten Stufe
nord = 128;     % Ordnung des Filters
hint1 = fir1(nord, 1/L1);     % FIR-Interpolationsfilter
hint2 = fir1(nord, 1/L2);     % FIR-Interpolationsfilter

% -------- Aufruf der Simulation
Tsim = 0.01;
sim('interpol3',[0:Ts/(L1*L2):Tsim]);   % Feste Schrittweite fr 
                                  % die Ergebnisse
y1 = y.Data(:,1);        % Mit Faktor L1*L2 interpoliertes Signal 
y2 = y.Data(:,2);        % Mit Ts abgetastetes Eingangssignal
y3 = y.Data(:,3);        % Analoges bandbegrenztes Eingangssignal
y4 = y.Data(:,4);        % Mit Faktor M = 147 dezimiertes Signal
t = y.Time;
figure(2);    clf; % ----------------------
subplot(211), plot(t, y3); hold on;
stairs(t, y2,'k');   stairs(t, y1,'k');    hold off;
La = axis;   axis([0.001, 0.002, La(3:4)]);    
title(['Analoges, mit Ts abgetastetes Eingangssignal und',...
    ' mit Faktor 160 interpoliertes Signal']);
xlabel('s');    grid on;
subplot(212), stairs(t, y2); hold on;
plot(t, y4);   hold off;
La = axis;   axis([0.001, 0.002, La(3:4)])
title(['Mit Ts abgetastetes Eingangssignal und',...
    ' mit Ts*L/M abgetastetes Ausgangssignal']);
xlabel('s');    grid on;


