% Skript interp_fft_1.m, in dem das Verfahren der Funktion 
% interpft untersucht wird

clear;
% -------- Die zu interpolierende Sequenz
N = 17;
s = rng;         % Um die gleiche Zufallssequenz zu erzeugen
x = randn(1,N);
rng(s);
% -------- Mit Nullwerten erweiterte Sequenz
L = 5;
y = zeros(1, L*N);
y(1:L:end) = x;
Yz = fft(y);
% -------- Spiegelungen entfernen mit der FFT
X = fft(x);
if rem(N,2) == 0
   Y = [X(1:N/2),0.5*X(N/2+1), zeros(1,N*(L-1)-1),0.5*X(N/2+1),...
       X(N/2+2:N)]; % Symmetrische FFT
   y = ifft(Y);    % Interpolierte Sequenz
else
   Y = [X(1:(N+1)/2), zeros(1,N*(L-1)), X((N+1)/2+1:N)]; % Symmetrische FFT
   y = ifft(Y);    % Interpolierte Sequenz
end;

yi = interpft(x, N*L);
figure(1);   clf;   %-----------------------
subplot(211), stem(0:L:(N-1)*L, x, '*');
title(['Die im Skript interpolierte Sequenz (L = ',num2str(L),')'])
hold on;    stem(0:L*N-1, L*y, 'k');     grid on;   xlabel('n');
hold off;  
subplot(212),  stem(0:L:(N-1)*L, x, '*');
title('Die mit interpft-Funktion interpolierte Sequenz')
hold on;    stem(0:L*N-1, yi, 'k');      grid on;   xlabel('n');
hold off;   

figure(2);    clf;
subplot(311), stem(0:N-1, abs(X));
title(['Betrag der DFT der ursprnglichen Sequenz N = ',num2str(N)])
xlabel('n');
subplot(312), stem(0:N*L-1, abs(Yz));
title(['Betrag der DFT der expandierten Sequenz N = ',num2str(N),...
    ' L = ',num2str(L)]);
xlabel('n');
subplot(313), stem(0:N*L-1, abs(Y));
title(['|DFT| der expandierten Sequenz mit Unterdrckung der Spiegelungen']);
xlabel('n');
