% Skript ifir_high_2.m zur Entwicklung eines 
% IFIR-Hochpassfilters mit der Funktion ifir
% Arbeitet mit Modell ifir_high2.slx

clear;
% -------- Gewnschte Parameter
fsp = 0.06;  % Sperrfrequenz
fp = 0.075;  % Durchlassfrequenz
fs = 1000;   Ts = 1/fs;
% -------- IFIR-Filter mit der Funktion ifir
L = 5;
[hup, hsupp, d]=ifir(L, 'high',[fsp, fp]*2,[0.0001, 0.001],'simple');
disp(['Versptung fuer den parallelen Pfad = ',...
    num2str(length(d)-1)]);
delay = length(d)-1;
hup = -hup;  % Um das HP-Filter mit der Differenz zu erhalten
% Frequenzgnge
nfft=1024;
Hup = fft(hup,nfft);    Hsupp = fft(hsupp,nfft);
figure(1);    clf;%-----------------
subplot(211), plot((0:nfft-1)*fs*L/nfft, 20*log10(abs(Hup.*Hsupp)));
title('Amplitudengang des IFIR-Tiefpassfilters');
xlabel('f/fs');     grid;
La = axis;   axis([La(1:2), -100, 10]);
subplot(212), plot((0:nfft-1)*fs*L/nfft, 20*log10(1 - abs(Hup.*Hsupp)));
title('Amplitudengang des IFIR-Hochpass-Struktur');
xlabel('f/fs');     grid;
La = axis;   axis([La(1:2), -100, 10]);

% -------- Aufruf der Simulation
fg1 = 200;     % Frequenz fr Generator 1 
fg2 = 600;     % Frequenz fr Generator 2
Tsim = 0.5;
sim('ifir_high2', [0,Tsim]);
t = y.Time;
y1 = y.Data(:,1);   % Ausgang des Delay-Blocks
y2 = y.Data(:,2);   % Ausgang des ifir-Tiefpassfilters
y3 = y.Data(:,3);   % Ausgang der ifir-high Struktur

figure(2);    clf;
subplot(311), plot(t, y1);
title(['Eingangssignal fg1 = ',num2str(fg1),' Hz; fg2 = ',...
    num2str(fg2),' Hz (Ausgang des Blocks Delay)']);
xlabel('s');    grid on;     La = axis;    axis([0.2, 0.25, La(3:4)]);
subplot(312), plot(t, y2);
title('Ausgangssignal des komplementren ifir-Tiefpassfilter');
xlabel('s');    grid on;     La = axis;    axis([0.2, 0.25, La(3:4)]);
subplot(313), plot(t, y3);
title('Ausgangssignal der ifir-Hochpass-Struktur');
xlabel('s');    grid on;     La = axis;    axis([0.2, 0.25, La(3:4)]);









