% Skript farrow_4.m in dem ein Farrow-Filter
% mit vernderlicher Versptung zur Abtastfreq-
% derung von 44,1 kHz auf 48 kHz untersucht wird
clear;
% ------- Entwicklung des Filters
L = 480;    M = 441;          % Abtastrate nderungsparameter
f = fdesign.polysrc(L,M);     % Filter-Objekt
f.PolynomialOrder = 3;        % Kubische-Interpolation
H = design(f, 'lagrange');    % Filter Entwurf
% ------- Beispiel fr eine Filterung
Ts = 1/44.1e3;      Tfinal = 0.005;
t = 0:Ts:Tfinal-Ts;
nt = length(t);
% ------- Bandbegrenztes Eingangssignal 
s = rng;       % Initialisierung des Zufallsgenerator (statt seed)
noise = randn(1,nt);     rng(s);
nord = 128;
x = filter(fir1(nord,0.1), 1, noise);  % Eingangssignal
% ------- Fractional-delay Filterung
y = filter(H, x);             % Ausgangssignal 
ny = length(y);
figure(1);   clf; %------------------
subplot(211), stem(t, x);    hold on;    plot(t, x);
stem((0:ny-1)*441*Ts/480-2*Ts, y,'r*');
hold off;
title('Signal und interpoliertes Signal mit Ts'' = 441*Ts/480');
xlabel('Zeit in s');    grid on;
La = axis;     axis([1e-3, Tfinal, La(3:4)]);
subplot(212), stem(t, x);    hold on;    plot(t, x);
stem((0:ny-1)*441*Ts/480-2*Ts, y,'r*');
hold off;
title(['Signal und interpoliertes Signal mit Ts'' = 441*Ts/480',...
    ' (Ausschnitt)']);
xlabel('Zeit in s');    grid on;
La = axis;     axis([2.3e-3, 3e-3, La(3:4)]);
% -------- Eingesetzte Versptungen
m = 0:1000;
del = mod(m*L/M, 1);     % Versptungen
k = find(del == 0),