% Skript farrow_3.m in dem ein Farrow-Filter
% mit vernderlicher Versptung untersucht wird
clear;
% ------- Entwicklung des Filters
L = 3;    M = 5;              % Abtastrate nderungsparameter
f = fdesign.polysrc(L,M);     % Filter-Objekt
f.PolynomialOrder = 3;        % Kubische-Interpolation
H = design(f, 'lagrange');    % Filter Entwurf
% ------- Beispiel fr eine Filterung
Ts = 2;      Tfinal = 500;
t = 0:Ts:Tfinal-Ts;
nt = length(t);
% ------- Bandbegrenztes Eingangssignal 
s = rng;       % Initialisierung des Zufallsgenerator (statt seed)
noise = randn(1,nt);     rng(s);
nord = 128;
x = filter(fir1(nord,0.1), 1, noise);  % Eingangssignal
% ------- Fractional-delay Filterung
y = filter(H, x);             % Ausgangssignal mit Ts' = 5Ts/3 
ny = length(y);

figure(1);   clf;
subplot(211), stem(t, x);         hold on;       plot(t, x);
stem((0:ny-1)*5*Ts/3-2*Ts, y,'r*');  hold off;
title('Signal und interpoliertes Signal mit Ts'' = 5Ts/3 ');
xlabel('Zeit in s');    grid on;
La = axis;    axis([100, 300, La(3:4)]);  % Ausschnitt
subplot(212), stem(t, x);         hold on;       plot(t, x);
stem((0:ny-1)*5*Ts/3-2*Ts, y,'r*');  hold off;
title('Signal und interpoliertes Signal mit Ts'' = 5Ts/3 (Ausschnitt)');
xlabel('Zeit in s');    grid on;
La = axis;    axis([300, 350, La(3:4)]);  % Ausschnitt