% Skript farrow_1.m, in dem ein Farrow 'Fractional Delay' Filter
% untersucht wird, das zu einer nicht rationalen Versptung fhrt

clear;
% -------- Parameter der Untersuchung
del = 0.8;     % Gewnschte Versptung
Hf_cub = fdesign.fracdelay(del, 3);   % Kubische Interpolation
Hcub = design(Hf_cub, 'Lagrange');    % Typ lagrange

% -------- Einheitspulsantwort des FIR-Filters
C = Hcub.Coefficients;     % Matrix C
lcub = C*[del^3, del^2, del, 1]';     % Polynome lk
hcub = flipud(lcub);       % Einheitspulsantwort des FIR-Filters
[Hfcub, w] = freqz(hcub,1);   % Frequenzgang

figure(1);    clf;
stem(0:length(hcub)-1, hcub);
title('Einheitspulsantwort des FIR-Kubischen-Filters');
xlabel('n');   grid on;
% -------- Frequenzgang
[Hfcub, w] = freqz(hcub,1);    % Frequenzgang
[gd, wd] = grpdelay(hcub,512); % Gruppenlaufzeit

figure(2);    clf;
subplot(311), plot(w/(2*pi), 20*log10(abs(Hfcub)));
title('Amplitudengang');   ylabel('dB');
xlabel('Relative Frequenz');    grid on;
subplot(312), plot(w/(2*pi), angle(Hfcub));
title('Phasengang');       ylabel('Rad');
xlabel('Relative Frequenz');    grid on;
subplot(313), plot(w/(2*pi), gd);
title('Gruppenlaufzeit in Abtastintervalle');
xlabel('Relative Freque ');    grid on;