% Skript dezimier_3.m, in dem ein Abwrtstaster
% mit FIR-Antialiasing Filter und diskretem Modell
% untersucht 
clear;
% --------- FIR-Tiefpassfilter fr das Nutzsignal
nord = 256;     
fp = 180;                   % Durchlassfrequenz
fs = 2000;    Ts = 1/fs;    % Ursprngliche Abtastperiode
hTP = fir1(nord, 2*fp/fs);
fst = 400;                  % Frequenz der Strung
% --------- Dezimierungsparameter
M = 5;
nord1 = 256;
hanti = fir1(nord1, 1/M);   % Antialiasing FIR-Filter
% --------- Aufruf der Simulation
Tsim = 1;
sim('dezimier3',[0:Ts:Tsim]);
y1 = y.Data(:,1);     % Signal vor dem Abwrtstaster
y2 = y.Data(:,2);     % Signal nach der Dezimierung
y3 = y.Data(:,3);     % Signal nach der Dezimierung als Pulse
y4 = y.Data(:,4);     % Signal mit Strung
y5 = y.Data(:,5);     % Signal ohne Strung (Nutzsignal)
t = y.Time;           % Simulationszeit

figure(1);   clf;
subplot(311);    stairs(t, y5);   hold on;  
stairs(t, y1);   hold off;
title(['Signal ohne Strung und Signal nach dem antialiasing',...
    ' FIR-Filter']);
xlabel('s');       grid on;
La = axis;    axis([0.2, 0.25, La(3:4)]);
subplot(312);    stairs(t, y1);   hold on;  
stairs(t, y4);   hold off;
title(['Signal mit Strung und Signal nach dem antialiasing',...
    ' FIR-Filter']);
xlabel('s');       grid on;
La = axis;    axis([0.2, 0.25, La(3:4)]);
subplot(313);    stairs(t, y1);   hold on;
hold on;   stairs(t, y2);   stairs(t,y3,'k');   hold off;
La = axis;    axis([0.2, 0.25, La(3:4)]);
grid on;
title(['Signal nach dem FIR-Filter, dezimiertes Signal'...
    ' und dezimiertes Signal als Pulse']);
xlabel('s');       grid on;
% --------- Spektralen  Leistungsdichten
nfft = 256;
[Y1,w] = pwelch(y1+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y2,w] = pwelch(y2+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y3,w] = pwelch(y3+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y31,w] = pwelch(y3*M+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y4,w] = pwelch(y4+j*eps,hamming(nfft),nfft/2,nfft,fs);

figure(2);   clf;
subplot(211), plot(w, 10*log10(Y4));
title(['Spektrum des Nutzsignals plus Strung ']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;
subplot(212), plot(w, 10*log10(Y1));
title(['Spektrum des Siganls ',...
    ' nach dem Antialiasing-Filter']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;


figure(3);   clf;
subplot(311); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y2));    hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (mit Halteglied nullter Ordnung)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;
subplot(312); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y3));    hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (als Pulse)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);
ylabel('dBWatt/Hz');    grid on;
subplot(313); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y31));   hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (als Pulse verstrkt mit Faktor M)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);
ylabel('dBWatt/Hz');    grid on;

% -------- Parseval Theorem
Pzeit = var(y4),          % Varianz
Pfreq = sum(Y4)*fs/nfft,  % Leistung aus der Spektralen Leistungsdichte




