% Skript dezimier_2.m, in dem ein Abwrtstaster
% untersucht wird mit diskretem Simulink-Modell

clear;
% --------- FIR-Tiefpassfilter fr das Nutzsignal
nord = 256;     
fp = 180;                   % Durchlassfrequenz
fs = 2000;    Ts = 1/fs;    % Ursprngliche Abtastperiode
hTP = fir1(nord, 2*fp/fs);
% --------- Dezimierungsparameter
M = 5;
% --------- Aufruf der Simulation
Tsim = 1;
options = simset('Solver','FixedStepDiscret');
sim('dezimier2',[0, Tsim], options);
y1 = y.Data(:,1);     % Signal vor der Dezimierung
y2 = y.Data(:,2);     % Signal nach der Dezinierung
y3 = y.Data(:,3);     % Signal nach der Dezimierung als Pulse
t = y.Time;           % Simulationszeit

figure(1);   clf;
stairs(t, y1);
hold on;   stairs(t, y2);   stairs(t,y3,'k');   hold off;
La = axis;    axis([0.2, 0.25, La(3:4)]);
grid on;
title(['Ursprngliches Signal', ', dezimiertes Signal'...
    ' und dezimiertes Signal als Pulse']);
xlabel('s');       grid on;
legend('Ursprngliches Signal','dezimiertes Signal',...
    'dezimiertes Signal als Pulse');
% --------- Spektralen  Leistungsdichten
nfft = 256;
[Y1,w] = pwelch(y1+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y2,w] = pwelch(y2+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y3,w] = pwelch(y3+j*eps,hamming(nfft),nfft/2,nfft,fs);
[Y31,w] = pwelch(y3*M+j*eps,hamming(nfft),nfft/2,nfft,fs);

figure(2);   clf;
subplot(311); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y2));    hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (mit halteglied nullter Ordnung)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;
subplot(312); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y3));    hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (als Pulse)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);
ylabel('dBWatt/Hz');    grid on;
subplot(313); plot(w, 10*log10(Y1));
hold on;      plot(w, 10*log10(Y31));   hold off;
title(['Spektrum des dezimierten Signals ',...
    ' (als Pulse verstrkt mit Faktor M)']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);
ylabel('dBWatt/Hz');    grid on;





