% Skript dezimier_11.m, in dem ein Abwrtstaster
% untersucht wird

clear;
% --------- Dezimierungsparameter
fs = 2000;    Ts = 1/fs;    % Ursprngliche Abtastperiode
M = 5;
% --------- Analoges Tiefpassfilter fr das Nutzsignal
nord = 6;     dp = 1;     ds = 60;
fp = 0.9*fs/(2*M);
[b,a] = ellip(nord, dp, ds, 2*pi*fp, 's');
% --------- Aufruf der Simulation
Tsim = 5;
sim('dezimier11',[0:Ts:Tsim]);
y1 = y.Data(:,1);     % Signal vor der Dezimierung
y2 = y.Data(:,2);     % Signal nach der Dezimierung
y3 = y.Data(:,3);     % Signal nach der Dezimierung als Pulse
t = y.Time;           % Simulationszeit

figure(1);   clf; %-------------------
subplot(211), stairs(t, y1);
hold on;   stairs(t, y1);   stairs(t,y2,'k');   hold off;
La = axis;    axis([0.2, 0.25, La(3:4)]);
grid on;
title(['Ursprngliches Signal und dezimiertes Signal']);
xlabel('s');       grid on;
subplot(212), stairs(t, y1);
hold on;   stairs(t, y1);   stairs(t,y2);   
stairs(t, y3,'k');     
La = axis;    axis([0.2, 0.25, La(3:4)]);
grid on;           hold off;
title(['Ursprngliches Signal, dezimiertes Signal und',...
    ' dezimiertes Signal als Pulse der Dauer Ts']);
xlabel('s');       grid on; 

% --------- Spektralen  Leistungsdichten
nfft = 256;
[Y1,w1] = pwelch(y1+j*eps,hamming(nfft),nfft/2,nfft,fs);
y2erw = zeros(1,length(y2));
y2erw(1:M:end) = y2(1:M:end); % Dezimierung um auf die Abtastperiode MTs zu gelangen
y2erw = y2erw*M;              % Die mittlere Leistung beibehalten
[Y2erw,w2] = pwelch(y2erw+j*eps,hamming(nfft),nfft/2,nfft,fs);
figure(2);   clf; %-------------------
subplot(211); plot(w1, 10*log10(Y1));
title(['Spektrum des Eingangssignals']);
xlabel([' Hz (fs = ',num2str(fs),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;
subplot(212); plot(w2, 10*log10(Y2erw)); 
title(['Spektrum des dezimierten Signals als Pulse der Dauer Ts']);
xlabel([' Hz (fs = ',num2str(fs/M),' Hz)']);  
ylabel('dBWatt/Hz');    grid on;





