% Skript basisband_2.m,in dem ein Bandpasssignal mit sehr
% kleiner Bandbreite gefiltert wird

clear;
% -------- Parameter des Systems
f0 = 40000;         % Mittefrequenz des Bandpasssignals (Trger)
delta_f1 = 200;     % Frequenz des Oberbandsignals
ampl1 = 1;          % Amplitude
delta_f2 = 300;     % Frequenz des Unterbandsignal
ampl2 = 0.5;        % Amplitude 

fs = 200000;        % Abtastfrequenz des Bandpasssignals
Ts = 1/fs;          % Abtastperiode
nord0 = 128;        % Ordnung des Filters fr die Strung
fnoise = [0.05, 0.3];% Bandbreite der Strung (relative Freq. MATLAB-Konv) 
% fnoise = 0.6;% Bandbreite der Strung (relative Freq. MATLAB-Konv) 
hnoise = fir1(nord0, fnoise);  % FIR-Bandpassfilter fr die Strung
noise = 0.5;        % Varianz des Rauschsignals

% -------- Filterung des Basisbandsignals in zwei Stufen
nord1 = 256;    M1 = 20;
hdez1 = fir1(nord1, 1/M1);    % FIR fr die Dezimierung
nord2 = 128;    fp2 = 0.1;     % FIR Kernfilter       
hdez2 = fir1(nord2, fp2);
delay = 2*nord1/2 + (nord2/2)*M1-1;
% -------- Aufruf der Simulation
Tsim = 0.8;
sim('basisband2',[0:Ts:Tsim]);
y1 = y.Data(:,1);    % Bandpasssignal mit Strung
y2 = y.Data(:,2);    % Rekonstruiertes Bandpasssignal
y3 = y.Data(:,3);    % Bandpasssignal ohne Strung

t = y.Time;

figure(1);     clf;
subplot(211); stairs(t, y1); 
title('Bandpasssignal mit Strung ');
xlabel('s');    grid on;
La = axis;    axis([0.372, 0.378, La(3:4)]);
subplot(212); stairs(t, y3); hold on;
stairs(t, y2);
title(['Bandpasssignal ohne Strung und Bandpasssignal',...
    ' nach der Filterung']);
xlabel('s');    grid on;
La = axis;    axis([0.372, 0.378, La(3:4)]); hold off;   



