% Skript zirk_faltung_1, in dem die zirkulre Faltung
% der DTFT des idealen Tiefpassfilter und der DTFT der
% rechteckigen Fenster-Funktion untersucht wird

clear;
% -------- Parameter
fs = 1000;      Ts = 1/fs;
fp = 200;
df = fs/1000;
f = -fs/2:df:fs/2;    nf = length(f);
N = 32;          % Ordnung des TP-Filters (N+1) Koeffizienten
                 % oder (N+1) Werte fr die Fensterfunktion
% -------- Idealer TP
H = zeros(1, nf);
p = find(f>-fp & f<fp);
H(p) = 1;

f0 = 180;        % Position der DTFT der Fenster-Funktion
figure(1);    clf;
subplot(221), pz1 = plot(f, H);
title(['Idealer Frequenzgang fs = ',num2str(fs),' Hz']);
xlabel('Hz');    grid on;  La = axis;   axis([La(1:2), -0.1, 1.1])
set(pz1.Parent,'XTick',[-500:100:500]);
W = (N+1)*diric(2*pi*(f-f0)*Ts, N+1); % DTFT der Fensterfunktion
subplot(223); pz2 = plot(f,W);
title(['DTFT der Fensterfunktion mit N+1 = ',num2str(N+1),' Werten']);
xlabel('Hz');    grid on;
set(pz2.Parent,'XTick',[-500:100:500]);

% -------- Zirkulre Faltung
Hr = zeros(1,nf);
for k = 1:nf
    f0 = f(k);     % Verschiebung der DTFT der Fensterfunktion
    W = (N+1)*diric(2*pi*(f-f0)*Ts, N+1);
    Hr(k) = sum(H.*W)*df/fs;  % Faltungswert bei F0
end;
subplot(122), pz3 = plot(f,H);  hold on;  plot(f, Hr);
hold off;
title('Zirkulre Faltung und idealer Frequenzgang');
xlabel('Hz');     grid on;
set(pz3.Parent,'XTick',[-500:100:500]);



    
    
    
    
    
    
    
    