% Skript zerophase_0.m, in dem eine Nullphase-Filterung
% mit ausgleich der Versptung eines kausalen FIR-Filters
% durchgefhrt wird

clear;
% -------- Parameter des kausalen FIR-Filters
nord = 64;    % Ordnung des Filters
fp = 0.2*2;   % TP-Filter mit Durchlassfrequenz (MATLAB-Konvention)
h = fir1(nord, fp);   % Einheitspulsantwort

% -------- Sprungsignal und Antwort
x = [zeros(1,40), ones(1,100)];  % Sprungsignal
nx = length(x);
y = filter(h,1,x);               % Kausale Antwort
yz = [y(nord/2:end), zeros(1,nord/2-1)]; % Entfernung 
    % der Versptung mit nord/2 des Filters  
figure(1);   clf;
subplot(311), plot(0:nx-1, x);
La = axis;    axis([0,100, La(3), 1.2]);
title('Eingangssprung');    xlabel('n');    grid on;
subplot(312), plot(0:nx-1, y);
La = axis;    axis([0,100, La(3:4)]);
La = axis;    axis([0,100, La(3:4)]);
title('Kausale Antwort');   xlabel('n');    grid on;
subplot(313), plot(0:nx-1, yz);
La = axis;    axis([0,100, La(3:4)]);
La = axis;    axis([0,100, La(3:4)]);
title('Nullphase Antwort'); xlabel('n');    grid on;
    
