% Skript sos_tf_1.m, in dem die sos- und tf-Implementierung
% bezglich numerischer Fehler untersucht wird.

clear;
% -------- Entwicklung eines IIR-Filters Typ Chebyschev I
fp = 0.2*2;     % Durchlassfrequenz (MATLAB-Konv.)
fst = 0.205*2;   % Stopfrequenz
fst = 0.215*2;   % Stopfrequenz
dp = 0.5;       % Welligkeit im Durchlassbereich
ds = 100;       % Dmpfung im Sperrbereich

Hf = fdesign.lowpass('Fp,Fst,Ap,Ast',fp,fst,dp,ds);
Hc = design(Hf, 'cheby1');
[b,a] = tf(Hc); % Umwandlung in tf-Form
nord = length(a)-1,   % Ordnung des Filters
% -------- Frequenzgnge der sos- und tf-Form
[H1,w1] = freqz(Hc);   % Frequenzgang der sos-Struktur
[H2,w2] = freqz(b,a);  % Frequenzgang der tf-Struktur

figure(1);   clf;
plot(w1/(2*pi), 20*log10(abs(H1)));
hold on;
plot(w2/(2*pi), 20*log10(abs(H2)), 'r');
hold off;
La = axis;    axis([La(1:2), -800, 50]);
title('Amplitudengang der sos- und tf-Filterstruktur');
xlabel('f/fs');   ylabel('dB');     grid on;