% Skript sgolay_1.m in dem ein Savitzky-Golay-Filter untersucht wird

clear;
% ------- Entwerfen der SG-Filter mit sgolay Funktion
k = 3;    % Grad des Interpolationspolynoms (N)
f = 9;    % f ist die Lnge der FIR-Filter (MR+ML+1)
b = sgolay(k,f);

figure(1);   clf;   % -----------
subplot(521), stem(0:f-1, b(1,:));
title('FIR-Filter b(1,:), fr den Transienten Anfangsteil');
xlabel('n');    grid on;
subplot(523), stem(0:f-1, b(2,:));
title('FIR-Filter b(2,:), fr den Transienten Anfangsteil');
xlabel('n');    grid on;
subplot(525), stem(0:f-1, b(3,:));
title('FIR-Filter b(3,:), fr den Transienten Anfangsteil');
xlabel('n');    grid on;
subplot(527), stem(0:f-1, b(4,:));
title('FIR-Filter b(4,:), fr den Transienten Anfangsteil');
xlabel('n');    grid on;
% ------- FIR-Filter fr den mittleren Teil der Sequenz
subplot(515), stem(0:f-1, b(5,:));
title('FIR-Filter b(5,:), fr den mittleren Teil der Sequenz');
xlabel('n');    grid on;

subplot(522), stem(0:f-1, b(6,:));
title('FIR-Filter b(6,:), fr den Transienten Endteil');
xlabel('n');    grid on;
subplot(524), stem(0:f-1, b(7,:));
title('FIR-Filter b(7,:), fr den Transienten Endteil');
xlabel('n');    grid on;
subplot(526), stem(0:f-1, b(8,:));
title('FIR-Filter b(8,:), fr den Transienten Endteil');
xlabel('n');    grid on;
subplot(528), stem(0:f-1, b(9,:));
title('FIR-Filter b(9,:), fr den Transienten Endteil');
xlabel('n');    grid on;
% --------- Filterung mit SG-Filter
randn('seed', 123987);
n = 50;
x = ones(1,n)+0.1*randn(1,n);
y = sgolayfilt(x,k,f);
figure(2);   clf;   % -----------
subplot(211), stem(0:n-1, x);
title('Eingangssequenz gleich eins plus Rauschanteil');
xlabel('n');      grid on;
subplot(212), stem(0:n-1, y);
title('Mit sgolayfilt gefilterte Sequenz');
xlabel('n');      grid on;

% -------- Filterung mit den FIR-Filtern aus Matrix b
y5 = filter(b(5,:),1,x);   % Filterung mit b(5,:)
figure(3);    clf;
subplot(311);
stem(0:n-1, [zeros(1,4),y5(9:end),zeros(1,4)]);
title('Gefilterte Sequenz mit dem mittleren FIR-Filter');
xlabel('n');    grid on;
hold on;
subplot(312);
title('Gefilterter Anfang- und Endtransientteil');
xlabel('n');    grid on;
hold on;
% ------- Transienter Teil vorne
y1 = dot(fliplr(b(9,:)),x(1:9));  % Berechnen des ersten
stem(0, y1,'o','k');    % Wertes des Transienten-Teils         
y2 = dot(fliplr(b(8,:)),x(1:9));  % Berechnen des zweiten
stem(1, y2,'o','k');    % Wertes des Transienten-Teils
y3 = dot(fliplr(b(7,:)),x(1:9));  % Berechnen des dritten
stem(2, y3,'o','k');    % Wertes des Transienten-Teils
y4 = dot(fliplr(b(6,:)),x(1:9));  % Berechnen des vierten
stem(3, y4,'o','k');    % Wertes des Transienten-Teils
% ------- Transienter Teil am Ende
y12 = dot(fliplr(b(1,:)),x(end-8:end));% Berechnen des letzten
stem(n-1, y12,'o','k');    % Wertes des Transienten-Teils
y22 = dot(fliplr(b(2,:)),x(end-8:end));% Berechnen des vorletzten
stem(n-2, y22,'o','k');    % Wertes des Transienten-Teils
y32 = dot(fliplr(b(3,:)),x(end-8:end));% ......
stem(n-3, y32,'o','k');
y42 = dot(fliplr(b(4,:)),x(end-8:end));
stem(n-4, y42,'o','k');
hold off;
% Zusammengefasste Teile
ysg = [y1, y2, y3, y4, y5(9:end),...
    y42, y32, y22, y12];
subplot(313), stem(0:n-1,ysg);% ---------
title('Zusammengestzte Sequenz');
xlabel('n');    grid on;




