% Skript sgolay_0.m, in dem die Einheitspulsantwort eines 
% Savitzky-Golay-Filters ermittelt und dargestellt wird

clear;
% ------- Parameter 
MR = 5;     % Anzahl der Sttzstellen rechts
ML = 2;     % Anzahl der Sttzstellen links
N = 4;      % Grad des Interpolationspolynoms

% ------- Einheitspulsantwort des Filters
xi = [zeros(1,ML), 1, zeros(1,MR)];  % Einganspuls
a = polyfit(-ML:MR,xi,N);   % Koeffizienten des Interpolations-
        % polynoms
y = polyval(a, -ML:MR);
ydicht = polyval(a,-ML:0.1:MR);
h = fliplr(y);           % Einheitspulsantwort des FIR-Filters
figure(1);    clf; % ---------
subplot(311), stem(-ML:MR, xi);
title('Einheitspuls bei n = 0 mit Umgebung');
xlabel('n');   grid on;
subplot(312), stem(-ML:MR, y);
title('Interpolierte Werte in der Umgebung von n = 0');
xlabel('n');   grid on;
hold on;   plot(-ML:0.1:MR, ydicht);
subplot(313), stem(-ML:MR, h);
title('Einheitspulsantwort des FIR-Filters');
xlabel('n');   grid on;

% ------- Interpolierter Wert bei n =  0;
y0 = dot(xi,y),  