% Skript sensor_diff_1.m, in dem das Differenzieren
% eines Signal mit eine FIR-Filter untersucht wird

clear;
% -------- Parameter
fsig = 100;      % Bandbreite des Beschleunigungssensors
sigma = 1;       % Varianz der Beschleunigung

% -------- Parameter des FIR-Differenzierers
fs = 1000;     Ts = 1/fs;    % Abtastfrequenz, Abtastperiode
% FIR-Filter
N = 33;                 % Ordnung des Filters (Typ IV)
b = firpm(N,[0,0.5]*2, [0, pi], 'differentiator');
nfft = 512;
[H,w] = freqz(b,1,nfft);     % Frequenzgang
figure(1);
subplot(211), stem(b)
title(['Einheitspulsantwort']);  xlabel('n');  grid on;
subplot(212), plot(w/(2*pi), abs(H));
title('Amplitudengang des Filters');
xlabel('f/fs');   grid on;

% -------- Aufruf der Simulation
delay = N*Ts/2;
Tsim = 1;
sim('sensor_diff1',[0, Tsim]);
t = y.time;
y1 = y.Data(:,1);     % Die versptete kontinuierliche Ableitung
y2 = y.Data(:,2);     % Ausgang des Differenzierers

figure(2);     clf;
plot(t, y.Data);
title(['Versptete kontinuierliche Ableitung und',...
    ' Ausgang des Differenzierers']);
xlabel('s');    grid on;
La = axis;    axis([0.5 0.6 La(3:4)]);

% ------- berprfen der Phase von pi/2
phi_komp = unwrap(angle(H)') + 2*pi*(0:nfft-1)/(2*nfft)*N/2;
